//	CDialog.c

#ifndef _H_CDialog
#define _H_CDialog

#include "Carbon68kGlue.h"
#include "CWindow.h"

class CDialog;

typedef struct {
	TEHandle	teH;
	short		itemHit;
	char		text[256];
	long		selStart;
	long		selEnd;
} TERestoreRec;

CDialog		*GetCDialog(WindowRef windowRef);

enum {
	DGI_KeyDown_NONE, 
	DGI_KeyDown_BAD, 
	DGI_KeyDown_GOOD,
	DGI_KeyDown_DONE, 
	DGI_KeyDown_EXIT, 
	DGI_KeyDown_NUMTYPES
};

typedef enum {
	DGI_ValueConvert_FROM, 
	DGI_ValueConvert_TO
} DGI_ValueConvertType;

typedef	struct {
	short				dlogItem;
	char				itemStr[256];
	short				justifyS;
	Style				face;
} DGI_ItemRec;

typedef short	Dlog_ItemIDType;
typedef short	Dlog_ItemStrType;

short		GetItemTableIndex(DGI_ItemRec *itemTable, short dlogItem, short maxItems);
void		SetControlRect(ControlHandle theControl, Rect *theRect);
void		SetModalUp(Boolean modalUpB);
Boolean		IsModalUp(void);

class CDialog : public CWindow {

	public: Boolean		IDialog(
		ADFS_WindowType windowType, 
		short			resourceID);
	
	virtual void		Dispose(void);
	
	/*********************************************/
	void				SetDlgItemUseStdDraw(short dItem);

	static pascal void	CB_S_DialogItemStandardDrawProc(
		DialogRef		theDialog, 
		DialogItemIndex	itemNo);
		
	virtual	void		DialogItemStandardDrawProc(
		DialogItemIndex	itemNo,
		Rect			*itemRectP);
		
	virtual	void		SetDlgItemUseStdDrawGroup(short startItem, short endItem);

	virtual	ControlRef	GetDlogItemControl(short dlgItem);

	virtual	DialogRef			GetDialogRef(void);
	virtual	WindowRef			GetWindowRef(void);
	virtual	GrafPtr				GetGrafPtr(void);

	void				InvalDialogItem(short dItem);

	virtual	void		ValueConvert(
		DGI_ValueConvertType	convertType, 
		short					dlgItem);

	virtual	void		SimulateClick(short dlgItem);

	virtual	void	Update(void);
	virtual	void	Idle(void);

	Rect		GetBestRect(short dlgItem);

	void		HideDlogItem(short dItem);
	void		ShowDlogItem(short dItem);

	void		HideDialogItemGroup(short firstItem, short lastItem);
	void		ShowDialogItemGroup(short firstItem, short lastItem);

	void		GetDlogItemRect(short dlgItem, Rect *theRect);
	void		SetDlogItemRect(short dlgItem, Rect *theRect);
	void		OffsetDlogItem(short dlgItem, short hOffset, short vOffset);

	void		GetDlogItemText(short dlgItem, char *text);
	void		SetDlogItemText(short dlgItem, char *text);

	TEHandle	GetDlogEditTextTE(short dlgItem);
	short		GetDlogTextRestore(TERestoreRec *restoreRec);
	void		RestoreDlogText(TERestoreRec *restoreRec);

	void		SelectDlogItem(short dlgItem);

	/*********************************************/
	UserItemUPP			i_dialog_UI_UPP; 

	private:
	typedef 	CWindow		_inherited;
};

#endif